<?php

defined('PF_VERSION') OR exit('Access denied');

/**
 *
 * @package		PageFlex
 * @author		PageFlex Team (phucpm.it@gmail.com)
 * @copyright           PageFlex Team
 * @link		http://page-flex.com
 * @since		Version 1.0
 * @filesource
 *
 */
class Pf_Page_Model extends Pf_Plugin_Model
{

    protected $table = 'pf_pages';
    protected $prefix_column = 'page';
    protected $primary_key = 'id';
    public $rules = array(
        'title' => 'required|max_len,255',
        'meta_title' => 'max_len,255', //min length 11
        'meta_keywords' => 'max_len,255',
        'meta_description' => 'max_len,255', //min length 20
        'content' => 'required,max_len,1000000', //4294967296
        'layout' => 'required'
    );

    /*
     * Data create
     */

    public function get_status_pages()
    {
        return array('1' => __('Published', 'page'), '0' => __('Unpublished', 'page'));
    }

    public function get_layout_pages()
    {
        $layouts = array('0' => __('Choose layout', 'page'));
        $rs = get_option('layouts');
        foreach ($rs as $v) {
            $layouts[$v['id']] = $v['layout_name'];
        }
        return $layouts;
    }

    public function get_sliders()
    {
        return array('0' => 'Slider 1', '1' => 'Slider 2');
    }

    public function get_page_type()
    {
        return array('0' => __('Default', 'page'), '1' => __('Landing page', 'page'));
    }

}
